# Video Anomaly Detection via Single Frame Supervision


## Abstract
Video Anomaly Detection (VAD) aims to identify anomalous frames in given videos. Existing fully-supervised VAD encounters substantial annotation cost and weakly-supervised VAD suffers from the deficiency of weak labels. In this paper, we propose a more effective Single Frame supervised VAD (SF-VAD), which leverages single abnormal frame as label. We argue that single abnormal frame annotation is highly efficient and it provides fine-grained dual references to abnormal and normal frames, which facilitate dependable anomaly and normality decoupling. Leveraging these dual references, we propose Frame-guided Probabilistic Contrary Learning (FPCL), to decouple contrary abnormal and normal patterns. Specifically, FPCL learns inclusive abnormal patterns reliably from mined abnormal frames, guided by similarity-based abnormal probability. Simultaneously, it decouples normal patterns in abnormal videos, by learning normal patterns in preceding frames, guided by Gaussian-prior normal probability. In inference, we additionally design temporal decoupling and boundary refining modules to reveal discriminative abnormal characters of temporal features. Extensive experiments show our SF-VAD method outperforms SOTA methods and achieves an optimal performance-cost trade-off. To support future research on this topic, we construct and release three SF-VAD datasets.


## Installation

```bash
pip install torch numpy tqdm pandas
```
## Datasets
For the **UCF-Crime** and **XD-Violence** datasets, we use off-the-shelf features extracted by [Wu et al](https://github.com/Roc-Ng). For the **ShanghaiTech** dataset, we used this [repo](https://github.com/v-iashin/video_features) to extract I3D features.
| Dataset     | Origin Video   | I3D Features  |
| -------- | -------- | -------- |
| &nbsp;&nbsp;UCF-Crime | &nbsp;&nbsp;[homepage](https://www.crcv.ucf.edu/projects/real-world/) | [download link](https://stuxidianeducn-my.sharepoint.com/:f:/g/personal/pengwu_stu_xidian_edu_cn/EvYcZ5rQZClGs_no2g-B0jcB4ynsonVQIreHIojNnUmPyA?e=xNrGxc) |
| &nbsp;XD-Violence | &nbsp;&nbsp;[homepage](https://roc-ng.github.io/XD-Violence/) | [download link](https://roc-ng.github.io/XD-Violence/) |
| ShanghaiTech | &nbsp;&nbsp;[homepage](https://svip-lab.github.io/dataset/campus_dataset.html) | [download link](https://drive.google.com/file/d/1kIv502RxQnMer-8HB7zrU_GU7CNPNNDv/view?usp=drive_link) |



## Training
```bash
python main.py
```
To train different datasets, please change the config file in main.py.

## Testing
Please add the ckpt option in config file, then run:
```bash
python main.py
```
to see the final results.